package gov.va.med.mhv.usermgmt.service.handler;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.config.ConfigurationManager;

/**
 * 
 *
 */
public class VapiiProperties {

	private static final Log LOG = LogFactory.getLog(VapiiProperties.class);
	private static final String RESOURCE_NAME = "/vapii.properties";
	
	private static VapiiProperties INSTANCE = new VapiiProperties();

	private final String vapiiEnvType;
	private final String vapiiUserIdType;
	private final String vapiiDevWsdlUrl;
	private final String vapiiIntbWsdlUrl;
	private final String vapiiSysTestWsdlUrl;
	private final String vapiiPreProdWsdlUrl;
	private final String vapiiProdWsdlUrl;
	private final String vapiiDevFormUrl;
	private final String vapiiIntbFormUrl;
	private final String vapiiSysTestFormUrl;
	private final String vapiiPreProdFormUrl;
	private final String vapiiProdFormUrl;

	public static VapiiProperties getInstance() {
		Properties properties = ConfigurationManager.getConfiguration(RESOURCE_NAME);
		boolean reloadCheck = Boolean.parseBoolean(properties.getProperty("vapii.property.reload","false"));
		if(reloadCheck) {
			INSTANCE = new VapiiProperties();
			return INSTANCE;
		}
		else
			return INSTANCE;
		//return (reloadCheck) ? new vapiiProperties() : INSTANCE;
	}
	public static VapiiProperties reInstance() {
		INSTANCE = new VapiiProperties();
		return INSTANCE;
	}

	private VapiiProperties() {
		Properties properties = ConfigurationManager.getConfiguration(RESOURCE_NAME);
		vapiiEnvType = (properties != null) ? (properties.getProperty("vapii.env.type")) : "";
		vapiiUserIdType = (properties != null) ? (properties.getProperty("vapii.user.id.type")) : "";
		
		vapiiDevWsdlUrl = (properties != null) ? (properties.getProperty("vapii.dev.wsdlurl")) : "";
		vapiiIntbWsdlUrl = (properties != null) ? (properties.getProperty("vapii.intb.wsdlurl")) : "";
		vapiiSysTestWsdlUrl = (properties != null) ? (properties.getProperty("vapii.systest.wsdlurl")) : "";
		vapiiPreProdWsdlUrl	= (properties != null) ? (properties.getProperty("vapii.preprod.wsdlurl")) : "";
		vapiiProdWsdlUrl = (properties != null) ? (properties.getProperty("vapii.prod.wsdlurl")) : "";
		
		vapiiDevFormUrl = (properties != null) ? (properties.getProperty("vapii.dev.formurl")) : "";
		vapiiIntbFormUrl = (properties != null) ? (properties.getProperty("vapii.intb.formurl")) : "";
		vapiiSysTestFormUrl = (properties != null) ? (properties.getProperty("vapii.systest.formurl")) : "";
		vapiiPreProdFormUrl	= (properties != null) ? (properties.getProperty("vapii.preprod.formurl")) : "";
		vapiiProdFormUrl = (properties != null) ? (properties.getProperty("vapii.prod.formurl")) : "";
		
		if (LOG.isInfoEnabled()) {
			LOG.info("Using the Following VAPii Properties: " + describe());
		}
	}

	public String describe() {
		StringBuilder builder = new StringBuilder();
		builder.append("\nvapiiProperties[");
		builder.append(" \nChosen ENVIRONMENT=").append(vapiiEnvType);
		builder.append(" \nChosen USER ID TYPE=").append(vapiiUserIdType);
		builder.append(" \nvapiiDevWsdlurl=").append(vapiiDevWsdlUrl);
		builder.append(" \nvapiiTestWsdlurl=").append(vapiiSysTestWsdlUrl);
		builder.append(" \nvapiiPreProdWsdlurl=").append(vapiiPreProdWsdlUrl);
		builder.append(" \nvapiiProdWsdlurl=").append(vapiiProdWsdlUrl);
		
		builder.append("\n]");
		return builder.toString();
	}

	public String getVapiiEnvType() {
		return vapiiEnvType;
	}
	
	public String getVapiiUserIdType() {
		return vapiiUserIdType;
	}
	
	public String getVapiiDevWsdlUrl() {
		return vapiiDevWsdlUrl;
	}
	
	public String getVapiiIntbWsdlUrl() {
		return vapiiIntbWsdlUrl;
	}
	
	public String getVapiiSysTestWsdlUrl() {
		return vapiiSysTestWsdlUrl;
	}

	public String getVapiiPreProdWsdlUrl() {
		return vapiiPreProdWsdlUrl;
	}
	
	public String getVapiiProdWsdlUrl() {
		return vapiiProdWsdlUrl;
	}
	
	public String getVapiiDevFormUrl() {
		return vapiiDevFormUrl;
	}
	
	public String getVapiiIntbFormUrl() {
		return vapiiIntbFormUrl;
	}
	
	public String getVapiiSysTestFormUrl() {
		return vapiiSysTestFormUrl;
	}

	public String getVapiiPreProdFormUrl() {
		return vapiiPreProdFormUrl;
	}
	
	public String getVapiiProdFormUrl() {
		return vapiiProdFormUrl;
	}
}
